

<?php $__env->startSection('title', __('Email Verification')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card card-bordered">
        <div class="card-inner card-inner-lg">
            <div class="nk-block-head text-center">
                <h4 class="nk-block-title"><?php echo e(__('Verify your email address')); ?></h4>
            </div>
            <div class="nk-block-content text-center">
                <p><?php echo __('Your email address (:mail) has not been verified yet! In order to start using your account, you need to confirm your email address first.', ['mail' => '<strong>'. $email .'</strong>' ]); ?></p>
                <p><?php echo e(__("If you did not receive the email, click the button to resend.")); ?></p>
                <form action="<?php echo e(route('auth.email.resend')); ?>" method="post">
                    <div class="form-group">
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-block btn-primary" ><?php echo e(__('Resend Email')); ?></button>
                    </div>
                    <div class="form-note">
                        <?php echo e(__("For account security, we required to verified your email address.")); ?>

                    </div>
                </form>
                <div class="divider"></div>
                <p><?php echo e(__("If you registered with wrong email address, update it now.")); ?></p>
                <form action="<?php echo e(route('auth.email.change')); ?>" method="post" class="form-validate is-alter">
                    <div class="form-group">
                        <div class="form-control-wrap">
                            <?php echo csrf_field(); ?>
                            <input type="email" name="email" class="form-control" placeholder="<?php echo e($email); ?>" data-msg-email="<?php echo e(__('Enter a valid email.')); ?>" data-msg-required="<?php echo e(__('Required.')); ?>" required>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error"><?php echo e($errors->first('email')); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="form-group mb-n3">
                        <ul class="btn-group-vertical align-center gy-3">
                            <li class="w-100"><button class="btn btn-block btn-light"><?php echo e(__('Update Email Address')); ?></button></li>
                            <li><a class="link link-primary" href="<?php echo e(route('auth.logout')); ?>" onclick="event.preventDefault(); document.getElementById('quick-logout').submit();"><?php echo e(__('Sign Out')); ?></a></li>
                        </ul>
                    </div>
                </form>
                <form id="quick-logout" action="<?php echo e(route('auth.logout')); ?>" method="POST" style="display: none;"><?php echo csrf_field(); ?></form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/auth/verify.blade.php ENDPATH**/ ?>