

<?php $__env->startSection('title', 'Admin Dashboard'); ?>

<?php

use App\Enums\TransactionCalcType;
use App\Enums\TransactionType;

$currency = base_currency();

?>

<?php $__env->startSection('content'); ?>
    <div class="nk-content-body">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between g-3">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title"><?php echo e(__("Overview")); ?></h3>
                    <div class="nk-block-des text-soft">
                        <p><?php echo e(__("Here is an insight of what's going on.")); ?></p>
                    </div>
                </div>
                <div class="nk-block-head-content">
                    <a href="<?php echo e(route('admin.transactions.list')); ?>" class="btn btn-primary d-none d-sm-inline-flex"><em class="icon ni ni-tranx"></em> <span><?php echo e(__("View Transaction")); ?></span></a>
                    <a href="<?php echo e(route('admin.transactions.list')); ?>" class="btn btn-icon btn-primary d-inline-flex d-sm-none"><em class="icon ni ni-tranx"></em></a>
                </div>
            </div>
        </div>
        <?php if(!count(available_payment_methods()) > 0 || count($pending) > 0): ?>
        <div class="nk-block">
            <?php if(!count(available_payment_methods())>0): ?>
            <div class="alert alert-danger alert-icon">
                <em class="icon ni ni-alert"></em>
                <strong><?php echo __("Important: Please setup at least one :link to receive payments.", ['link' => '<a href="'.route('admin.settings.gateway.payment.list').'" class="alert-link">'.__("payment method").'</a>']); ?></strong>
            </div>
            <?php endif; ?>
            <?php if(count($pending)>0): ?>
            <div class="nk-alert-action g-1">
                <div class="nk-alert-message">
                    <div class="nk-alert-icon"><em class="icon ni ni-info"></em></div>
                    <div class="nk-alert-text"><span><?php echo e(__("Attention:")); ?></span> <?php echo e(__("You have few pending request, that need to review.")); ?></div>
                </div>
                <div class="nk-alert-nav">
                    <ul class="nk-alert-links gx-4">
                    <?php $__currentLoopData = $pending; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(route('admin.transactions.list', $type->type)); ?>"><?php echo e($type->total); ?> <?php echo e(strtoupper($type->type)); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        <div class="nk-block">
            <div class="row g-gs">
                <div class="col-lg-8">
                    <div class="card card-bordered">
                        <div class="card-inner">
                            <div class="card-title-group align-start mb-3">
                                <div class="card-title">
                                    <h6 class="title"><?php echo e(__("Daily Insight")); ?></h6>
                                    <p><?php echo e(__("Daywise overall depsoit & withdraw.")); ?></p>
                                </div>
                                <div class="card-tools mt-n1 mr-n1">
                                    <div class="drodown">
                                        <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                        <div class="dropdown-menu dropdown-menu-sm dropdown-menu-right">
                                            <ul class="link-list-opt no-bdr">
                                                <li><a href="<?php echo e(route('admin.dashboard')); ?>?days=15"
                                                <?php if((request()->has('days') && request()->days==15) ||!request()->has('days')): ?> class="active" <?php endif; ?>
                                                ><span><?php echo e(__("15 Days")); ?></span></a></li>
                                                <li><a href="<?php echo e(route('admin.dashboard')); ?>?days=30"
                                                <?php if(request()->has('days') && request()->days==30): ?> class="active" <?php endif; ?>
                                                ><span><?php echo e(__("30 Days")); ?></span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="nk-insight">
                                <div class="row g-4 align-end">
                                    <div class="col-xxl-8">
                                        <div class="nk-insight-ck">
                                            <canvas class="chart-insight" id="inoutOverview"></canvas>
                                        </div>
                                    </div>
                                    <div class="col-xxl-4">
                                        <div class="row g-4">
                                            <div class="col-sm-6 col-xxl-12">
                                                <div class="nk-insight-data payin">
                                                    <div class="amount"><?php echo e(to_amount($deposit['total'], $currency)); ?> <small class="currency"><?php echo e($currency); ?></small></div>
                                                    <div class="info"><?php echo e(__("Last month")); ?> <strong><?php echo e(to_amount($deposit['last_month'], $currency)); ?> <span class="currency"><?php echo e($currency); ?></span></strong></div>
                                                    <div class="title"><em class="icon ni ni-arrow-down-left"></em> <?php echo e(__("Deposit")); ?></div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-xxl-12">
                                                <div class="nk-insight-data payout">
                                                    <div class="amount"><?php echo e(to_amount($withdraw['total'], $currency)); ?> <small class="currency"><?php echo e($currency); ?></small></div>
                                                    <div class="info"><?php echo e(__("Last month")); ?> <strong> <?php echo e(to_amount($withdraw['last_month'], $currency)); ?> <span class="currency"><?php echo e($currency); ?></span></strong></div>
                                                    <div class="title"><em class="icon ni ni-arrow-up-right"></em> <?php echo e(__("Withdraw")); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="row g-gs">
                        <div class="col-md-6 col-lg-12">
                            <div class="card card-bordered">
                                <div class="card-inner">
                                    <div class="card-title-group align-start mb-0">
                                        <div class="card-title">
                                            <h6 class="subtitle text-base"><?php echo e(__("Total Deposit")); ?></h6>
                                        </div>
                                        <div class="card-tools">
                                            <em class="card-hint icon ni ni-help-fill" data-toggle="tooltip" data-placement="left" title="<?php echo e(__("The total amount of depsoit all the time.")); ?>"></em>
                                        </div>
                                    </div>
                                    <div class="card-amount">
                                        <span class="amount"> <?php echo e(to_amount($deposit['total'], $currency)); ?> <span class="currency"><?php echo e($currency); ?></span>
                                        </span>
                                    </div>
                                    <div class="card-stats">
                                        <div class="card-stats-group g-2">
                                            <div class="card-stats-data">
                                                <div class="title"><?php echo e(__("This Month")); ?></div>
                                                <div class="amount"> <?php echo e(to_amount($deposit['this_month'], $currency)); ?>

                                                    <?php if($deposit['prtc_monthly'] > 0): ?>
                                                        <span class="change up tipinfo" title="<?php echo e(__("Than last month")); ?>">
                                                        <em class="icon ni ni-arrow-long-up"></em><?php echo e(abs($deposit['prtc_monthly'])); ?>%</span>
                                                    <?php elseif($deposit['prtc_monthly'] < 0): ?>
                                                        <span class="change down tipinfo" title="<?php echo e(__("Than last month")); ?>">
                                                        <em class="icon ni ni-arrow-long-down"></em><?php echo e(abs($deposit['prtc_monthly'])); ?>%</span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="card-stats-data">
                                                <div class="title"><?php echo e(__("This Week")); ?></div>
                                                <div class="amount">  <?php echo e(to_amount($deposit['this_week'], $currency)); ?>

                                                    <?php if($deposit['prtc_weekly'] > 0): ?>
                                                        <span class="change up tipinfo" title="<?php echo e(__("Than last month")); ?>">
                                                        <em class="icon ni ni-arrow-long-up"></em><?php echo e(abs($deposit['prtc_weekly'])); ?>%</span>
                                                    <?php elseif($deposit['prtc_weekly'] < 0): ?>
                                                        <span class="change down tipinfo" title="<?php echo e(__("Than last month")); ?>">
                                                        <em class="icon ni ni-arrow-long-down"></em><?php echo e(abs($deposit['prtc_weekly'])); ?>%</span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-stats-ck">
                                            <canvas class="chart-liner" id="totalDeposit"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-12">
                            <div class="card card-bordered">
                                <div class="card-inner">
                                    <div class="card-title-group align-start mb-0">
                                        <div class="card-title">
                                            <h6 class="subtitle text-base"><?php echo e(__("Total Withdraw")); ?></h6>
                                        </div>
                                        <div class="card-tools">
                                            <em class="card-hint icon ni ni-help-fill" data-toggle="tooltip" data-placement="left" title="<?php echo e(__("The total amount of withdraw all the time.")); ?>"></em>
                                        </div>
                                    </div>
                                    <div class="card-amount">
                                        <span class="amount"> <?php echo e(to_amount($withdraw['total'], $currency)); ?> <span class="currency"><?php echo e($currency); ?></span>
                                        </span>
                                    </div>
                                    <div class="card-stats">
                                        <div class="card-stats-group g-2">
                                            <div class="card-stats-data">
                                                <div class="title"><?php echo e(__("This Month")); ?></div>
                                                <div class="amount"> <?php echo e(to_amount($withdraw['this_month'], $currency)); ?>

                                                    <?php if($withdraw['prtc_monthly'] > 0): ?>
                                                        <span class="change up tipinfo" title="<?php echo e(__("Than last month")); ?>">
                                                        <em class="icon ni ni-arrow-long-up"></em><?php echo e(abs($withdraw['prtc_monthly'])); ?>%</span>
                                                    <?php elseif($withdraw['prtc_monthly'] < 0): ?>
                                                        <span class="change down tipinfo" title="<?php echo e(__("Than last month")); ?>">
                                                        <em class="icon ni ni-arrow-long-down"></em><?php echo e(abs($withdraw['prtc_monthly'])); ?>%</span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="card-stats-data">
                                                <div class="title"><?php echo e(__("This Week")); ?></div>
                                                <div class="amount"> <?php echo e(to_amount($withdraw['this_week'], $currency)); ?>

                                                    <?php if($withdraw['prtc_weekly'] > 0): ?>
                                                        <span class="change up tipinfo" title="<?php echo e(__("Than last month")); ?>">
                                                        <em class="icon ni ni-arrow-long-up"></em><?php echo e(abs($withdraw['prtc_weekly'])); ?>%</span>
                                                    <?php elseif($withdraw['prtc_weekly'] < 0): ?>
                                                        <span class="change down tipinfo" title="<?php echo e(__("Than last month")); ?>">
                                                        <em class="icon ni ni-arrow-long-down"></em><?php echo e(abs($withdraw['prtc_weekly'])); ?>%</span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-stats-ck">
                                            <canvas class="chart-liner" id="totalWithdraw"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xxl-4">
                    <div class="card card-bordered card-full">
                        <div class="card-inner border-bottom">
                            <div class="card-title-group">
                                <div class="card-title">
                                    <h6 class="title"><?php echo e(__("Transactions")); ?></h6>
                                </div>
                                <div class="card-tools">
                                    <ul class="card-tools-nav nav">
                                        <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#tnxin"><span><?php echo e(__("In")); ?></span></a></li>
                                        <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#tnxout"><span><?php echo e(__("Out")); ?></span></a></li>
                                        <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#tnxall"><span><?php echo e(__("All")); ?></span></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content mt-0">
                            <div class="tab-pane active" id="tnxall">
                                <div class="nk-tnx-pro is-scrollable h-425px" data-simplebar>
                                    <?php if(filled($transactions['all_tnx'])): ?>
                                        <?php $__currentLoopData = $transactions['all_tnx']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tnx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($tnx->calc===TransactionCalcType::CREDIT): ?>
                                        <div class="nk-tnx-pro-item">
                                            <div class="nk-tnx-pro-col">
                                                <ul class="icon-overlap-alt">
                                                    <li><em class="bg-success-dim icon-circle icon ni ni-arrow-down-left"></em></li>
                                                    <li><em class="bg-white icon-circle md icon ni ni-sign-<?php echo e(strtolower($tnx->tnx_currency)); ?>"></em></li>
                                                </ul>
                                                <div class="nk-tnx-pro-data">
                                                    <div class="label"><?php echo e($tnx->type_of_fund); ?></div>
                                                    <div class="date"><?php echo e(show_date($tnx->completed_at)); ?> <span class="d-none d-sm-inline"><?php echo e(show_time($tnx->completed_at)); ?></span></div>
                                                </div>
                                            </div>
                                            <div class="nk-tnx-pro-col">
                                                <div class="nk-tnx-pro-amount">
                                                    <div class="amount">+ <?php echo e(to_amount($tnx->tnx_amount, $tnx->tnx_currency)); ?> <span class="currency"><?php echo e($tnx->tnx_currency); ?></span></div>
                                                    <div class="amount-sm up">+ <?php echo e(to_amount($tnx->amount, $tnx->currency)); ?> <span class="currency"><?php echo e($tnx->currency); ?></span></div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php elseif($tnx->calc===TransactionCalcType::DEBIT): ?>
                                        <div class="nk-tnx-pro-item">
                                            <div class="nk-tnx-pro-col">
                                                <ul class="icon-overlap-alt">
                                                    <li><em class="bg-warning-dim icon-circle icon ni ni-arrow-up-right"></em></li>
                                                    <li><em class="bg-white icon-circle md icon ni ni-sign-<?php echo e(strtolower($tnx->tnx_currency)); ?>"></em></li>
                                                </ul>
                                                <div class="nk-tnx-pro-data">
                                                    <div class="label"><?php echo e($tnx->type_of_fund); ?></div>
                                                    <div class="date"><?php echo e(show_date($tnx->completed_at)); ?> <span class="d-none d-sm-inline"><?php echo e(show_time($tnx->completed_at,true)); ?></span></div>
                                                </div>
                                            </div>
                                            <div class="nk-tnx-pro-col">
                                                <div class="nk-tnx-pro-amount">
                                                    <div class="amount">- <?php echo e(to_amount($tnx->tnx_amount, $tnx->tnx_currency)); ?> <span class="currency"> <?php echo e($tnx->tnx_currency); ?></span></div>
                                                    <div class="amount-sm down">- <?php echo e(to_amount($tnx->amount, $tnx->currency)); ?> <span class="currency"><?php echo e($tnx->currency); ?></span></div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <div class="no-result py-5 px-1 text-center d-block">
                                            <span class="icon-circle icon-circle-lg icon-lg text-gray bg-white"><em class="icon ni ni-info"></em></span>
                                            <span class="d-block font-italic small"><?php echo e(__("No transaction available!")); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="tab-pane" id="tnxout">
                                <div class="nk-tnx-pro is-scrollable h-425px" data-simplebar>
                                    <?php if(filled($transactions['debits'])): ?>
                                        <?php $__currentLoopData = $transactions['debits']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $debit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="nk-tnx-pro-item">
                                            <div class="nk-tnx-pro-col">
                                                <ul class="icon-overlap-alt">
                                                    <li><em class="bg-warning-dim icon-circle icon ni ni-arrow-up-right"></em></li>
                                                    <li><em class="bg-white icon-circle md icon ni ni-sign-<?php echo e(strtolower($debit->tnx_currency)); ?>"></em></li>
                                                </ul>
                                                <div class="nk-tnx-pro-data">
                                                    <div class="label"><?php echo e($debit->type_of_fund); ?></div>
                                                    <div class="date"><?php echo e(show_date($debit->completed_at)); ?> <span class="d-none d-sm-inline"><?php echo e(show_time($debit->completed_at)); ?></span></div>
                                                </div>
                                            </div>
                                            <div class="nk-tnx-pro-col">
                                                <div class="nk-tnx-pro-amount">
                                                    <div class="amount">- <?php echo e(to_amount($debit->tnx_amount, $debit->tnx_currency)); ?> <span class="currency"><?php echo e($debit->tnx_currency); ?></span></div>
                                                    <div class="amount-sm down">- <?php echo e(to_amount($debit->amount, $currency)); ?> <span class="currency"><?php echo e($debit->currency); ?></span></div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <div class="no-result py-5 px-1 text-center d-block">
                                            <span class="icon-circle icon-circle-lg icon-lg text-gray bg-white"><em class="icon ni ni-info"></em></span>
                                            <span class="d-block font-italic small"><?php echo e(__("No transaction available!")); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="tab-pane" id="tnxin">
                                <div class="nk-tnx-pro is-scrollable h-425px" data-simplebar>
                                <?php if(filled($transactions['credits'])): ?>
                                    <?php $__currentLoopData = $transactions['credits']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="nk-tnx-pro-item">
                                        <div class="nk-tnx-pro-col">
                                            <ul class="icon-overlap-alt">
                                                <li><em class="bg-success-dim icon-circle icon ni ni-arrow-down-left"></em></li>
                                                <li><em class="bg-white icon-circle md icon ni ni-sign-<?php echo e(strtolower($credit->tnx_currency)); ?>"></em></li>
                                            </ul>
                                            <div class="nk-tnx-pro-data">
                                                <div class="label"><?php echo e($credit->type_of_fund); ?></div>
                                                <div class="date"><?php echo e(show_date($credit->completed_at)); ?> <span class="d-none d-sm-inline"><?php echo e(show_time($credit->completed_at)); ?></span></div>
                                            </div>
                                        </div>
                                        <div class="nk-tnx-pro-col">
                                            <div class="nk-tnx-pro-amount">
                                                <div class="amount">+ <?php echo e(to_amount($credit->tnx_amount, $credit->tnx_currency)); ?> <span class="currency"><?php echo e($credit->tnx_currency); ?></span></div>
                                                <div class="amount-sm up">+ <?php echo e(to_amount($credit->amount, $credit->currency)); ?> <span class="currency"><?php echo e($credit->currency); ?></span></div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <div class="no-result py-5 px-1 text-center d-block">
                                        <span class="icon-circle icon-circle-lg icon-lg text-gray bg-white"><em class="icon ni ni-info"></em></span>
                                        <span class="d-block font-italic small"><?php echo e(__("No transaction available!")); ?></span>
                                    </div>
                                <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xxl-4">
                    <div class="card card-bordered card-full">
                        <div class="card-inner">
                            <div class="card-title-group">
                                <div class="card-title">
                                    <h6 class="title"><?php echo e(__("Investment Activities")); ?></h6>
                                </div>
                                <div class="card-tools">
                                    <a href="<?php echo e(route('admin.investment.list')); ?>" class="link"><?php echo e(__("All investments")); ?></a>
                                </div>
                            </div>
                        </div>
                        <div class="card-inner p-0 border-top">
                            <div class="nk-olistr is-scrollable h-425px" data-simplebar>
                                <div class="nk-tb-list nk-tb-orders">
                                <?php if(filled($transactions['investments'])): ?>
                                    <?php $__currentLoopData = $transactions['investments']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="nk-tb-item">
                                        <div class="nk-tb-col nk-tb-orders-type">
                                            <ul class="user-avatar user-avatar-sm bg-light">
                                                <span><?php echo e(strtoupper(substr($iv->scheme['short'], 0, 2))); ?></span>
                                            </ul>
                                        </div>
                                        <div class="nk-tb-col">
                                            <span class="tb-lead"><?php echo e($iv->scheme['name']); ?> <span class="d-none d-md-inline">- <?php echo e($iv->calc_details); ?></span></span>
                                            <div class="date"><?php echo e(show_date($iv->created_at)); ?> <span class="d-none d-sm-inline"><?php echo e(show_time($credit->created)); ?></span></div>
                                        </div>
                                        <div class="nk-tb-col text-right">
                                            <span class="tb-amount-lg">+ <?php echo e(to_amount($iv->amount, $currency)); ?> <span class="currency"><?php echo e($currency); ?></span></span>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <div class="no-result py-5 px-1 text-center d-block">
                                        <span class="icon-circle icon-circle-lg icon-lg text-gray bg-white"><em class="icon ni ni-info"></em></span>
                                        <span class="d-block font-italic small"><?php echo e(__("No activities available!")); ?></span>
                                    </div>
                                <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 col-xxl-4">
                    <div class="row g-gs">
                        <div class="col-md-6 col-xxl-12">
                            <div class="card card-bordered">
                                <div class="card-inner">
                                    <div class="card-title-group align-start mb-3">
                                        <div class="card-title">
                                            <h6 class="title"><?php echo e(__("User Activities")); ?></h6>
                                            <p><?php echo e(__("In last 30 days")); ?> <em class="icon ni ni-info" data-toggle="tooltip" data-placement="right" title="Signup Activities"></em></p>
                                        </div>
                                    </div>
                                    <div class="join-insight-group g-4">
                                        <div class="join-insight">
                                            <em class="icon ni ni-users"></em>
                                            <div class="info">
                                                <span class="amount"><?php echo e($stats['this_month']); ?></span>
                                                <span class="title"><?php echo e(__("Direct Join")); ?></span>
                                            </div>
                                        </div>
                                        <div class="join-insight">
                                            <em class="icon ni ni-share"></em>
                                            <div class="info">
                                                <span class="amount"><?php echo e($stats['ref_count']); ?></span>
                                                <span class="title"><?php echo e(__("Referral Join")); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="join-insight-ck">
                                    <canvas class="chart-bar" id="userStats"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-xxl-12">
                            <div class="card card-bordered">
                                <div class="card-inner">
                                    <div class="card-title-group align-start mb-3">
                                        <div class="card-title">
                                            <h6 class="title"><?php echo e(__("Total Stats")); ?></h6>
                                        </div>
                                        <div class="card-tools">
                                        </div>
                                        <em class="card-hint icon ni ni-help-fill" data-toggle="tooltip" data-placement="left" title="Total statistics number."></em>
                                    </div>
                                    <div class="nk-ovb">
                                        <div class="nk-ovb-data-group g-4">
                                            <div class="nk-ovb-data">
                                                <div class="title"><span class="dot dot-lg sq" data-bg="#f7bf90"></span><span><?php echo e(__("Deposits")); ?></span></div>
                                                <div class="amount"><?php echo e($transactions['dp_count']); ?></div>
                                                <div class="amount-sm"><?php echo e($transactions['dp_since']); ?> <small><?php echo e(__("since last month")); ?></small></div>
                                            </div>
                                            <div class="nk-ovb-data">
                                                <div class="title"><span class="dot dot-lg sq" data-bg="#ffa9ce"></span><span><?php echo e(__("Withdraws")); ?></span></div>
                                                <div class="amount"><?php echo e($transactions['wd_count']); ?></div>
                                                <div class="amount-sm"><?php echo e($transactions['wd_since']); ?> <small><?php echo e(__("since last month")); ?></small></div>
                                            </div>
                                            <div class="nk-ovb-data">
                                                <div class="title"><span class="dot dot-lg sq" data-bg="#b8acff"></span><span><?php echo e(__("Transactions")); ?></span></div>
                                                <div class="amount"><?php echo e($transactions['tnx_count']); ?></div>
                                                <div class="amount-sm"><?php echo e($transactions['tnx_since']); ?> <small><?php echo e(__("since last month")); ?></small></div>
                                            </div>
                                            <div class="nk-ovb-data">
                                                <div class="title"><span class="dot dot-lg sq" data-bg="#9cabff"></span><span><?php echo e(__("Users")); ?></span></div>
                                                <div class="amount"><?php echo e($stats['user_count']); ?></div>
                                                <div class="amount-sm"><?php echo e($stats['this_month']); ?> <small><?php echo e(__("since last month")); ?></small></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<?php
    $inout = array_merge(array_values($dailyInsights['deposit']), array_values($dailyInsights['withdraw']));
    $minio = array_filter($inout, function($item){ return $item > 0; });
    $max = max($inout);
    $min = (is_array($minio) && !empty($minio)) ? (min($minio) === $max ? 0 : min($minio)) : 0;
?>
<script>
    var totalDeposit = {
        tooltip: true, tooltipStyle: 'single', dataUnit : '<?php echo e($currency); ?>', stacked : false, labels : <?php echo json_encode(array_keys($dailyInsights['deposit']), 15, 512) ?>,
        datasets : [{ label : "<?php echo e(__("Depsoit")); ?>", color : "#6576ff", background : 'gradient', borderWidth: 2, data: <?php echo json_encode(array_values($dailyInsights['deposit']), 15, 512) ?> }]
    };

    var totalWithdraw = {
        tooltip: true, tooltipStyle: 'single', dataUnit: '<?php echo e($currency); ?>', stacked: false, labels: <?php echo json_encode(array_keys($dailyInsights['withdraw']), 15, 512) ?>,
        datasets: [{ label: "<?php echo e(__("Withdraw")); ?>", color: "#e85347", background: 'gradient', borderWidth: 2, data: <?php echo json_encode(array_values($dailyInsights['withdraw']), 15, 512) ?> }]
    };

    var inoutOverview = {
        tooltip: true, dataUnit: '<?php echo e($currency); ?>', stacked: false, lineTension: 1, labels: <?php echo json_encode(array_keys($dailyInsights['deposit']), 15, 512) ?>,
        scales: { min: <?php echo e($min); ?>, max: <?php echo e($max); ?>, step: <?php echo e(round($max / 10, 0)); ?> },
        datasets: [
            { label: "<?php echo e(__("Depsoit")); ?>", color: NioApp.hexRGB('#6576ff', 1), borderWidth: 3, data: <?php echo json_encode(array_values($dailyInsights['deposit']), 15, 512) ?> },
            { label: "<?php echo e(__("Withdraw")); ?>", color: NioApp.hexRGB('#e85347', .6), borderWidth: 3, data: <?php echo json_encode(array_values($dailyInsights['withdraw']), 15, 512) ?> }
        ]
    };

    var userStats = {
        tooltip: true, legend: false, dataUnit: '<?php echo e(__("Member")); ?>', stacked: true, lineTension: .4, labels: <?php echo json_encode(array_keys($stats['directGraph']), 15, 512) ?>,
        datasets: [
            { label: "<?php echo e(__("Direct")); ?>", color: "#798bff", data: <?php echo json_encode(array_values($stats['directGraph']), 15, 512) ?> },
            { label: "<?php echo e(__("Referral")); ?>", color: "#ccd4ff", data: <?php echo json_encode(array_values($stats['referralGraph']), 15, 512) ?> }
        ]
    };
</script>
<script src=<?php echo e(asset('assets/js/charts.js')); ?>></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>