

<?php $__env->startSection('title', 'Register'); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-bordered">
    <div class="card-inner card-inner-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?php echo e(__('Create an Account')); ?></h4>
                <div class="nk-block-des mt-2">
                    <?php if($user_counts!=0): ?>
                    <p><?php echo e(__('Sign up with your email and get started with your free account.')); ?></p>
                    <?php endif; ?>
                </div>
                <?php if($user_counts==0): ?>
                <div class="alert alert-fill alert-primary alert-icon mt-3">
                    <em class="icon ni ni-user"></em> <?php echo e(__("Register a regular admin account first.")); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php echo $__env->make('auth.partials.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <form action="<?php echo e(route('auth.register')); ?>" autocomplete="off" method="POST" id="registerForm" class="form-validate is-alter" autocomplete="off">
            <div class="form-group">
                <label class="form-label" for="full-name"><?php echo e(__('Full Name')); ?><span class="text-danger"> &nbsp;*</span></label>
                <div class="form-control-wrap">
                    <input type="text" id="full-name" name="name" value="<?php echo e(old('name')); ?>" class="form-control form-control-lg<?php echo e(($errors->has('name')) ? ' error' : ''); ?>" minlength="3" data-msg-required="<?php echo e(__('Required.')); ?>" data-msg-minlength="<?php echo e(__('At least :num chars.', ['num' => 3])); ?>" required>
                </div>
            </div>
            <div class="form-group">
                <label class="form-label" for="email-address"><?php echo e(__('Email Address')); ?><span class="text-danger"> &nbsp;*</span></label>
                <div class="form-control-wrap">
                    <input type="email" id="email-address" name="email" value="<?php echo e(old('email')); ?>" class="form-control form-control-lg<?php echo e(($errors->has('email')) ? ' error' : ''); ?>" autocomplete="off" data-msg-email="<?php echo e(__('Enter a valid email.')); ?>" data-msg-required="<?php echo e(__('Required.')); ?>" required>
                </div>
            </div>
            <div class="form-group">
                <label class="form-label" for="passcode"><?php echo e(__('Password')); ?><span class="text-danger"> &nbsp;*</span></label>
                <div class="form-control-wrap">
                    <a tabindex="-1" href="#" class="form-icon form-icon-right passcode-switch" data-target="passcode">
                        <em class="passcode-icon icon-show icon ni ni-eye-off"></em>
                        <em class="passcode-icon icon-hide icon ni ni-eye"></em>
                    </a>
                    <input name="password" id="passcode" type="password" autocomplete="new-password" class="form-control form-control-lg" minlength="6" data-msg-required="<?php echo e(__('Required.')); ?>" data-msg-minlength="<?php echo e(__('At least :num chars.', ['num' => 6])); ?>" required>
                </div>
            </div>
            <?php if($user_counts!=0): ?>
            <div class="form-group">
                <div class="custom-control custom-control-xs custom-checkbox">
                    <input type="checkbox" name="confirmation" class="custom-control-input<?php echo e($errors->has('confirmation') ? ' error' : ''); ?>" id="checkbox" data-msg-required=" <?php echo e(__("You should accept our terms.")); ?>" required>
                    <label class="custom-control-label" for="checkbox"><?php echo __('I have agree to the :terms', ['terms' => get_page_link('terms', __("Terms & Condition"), true)]); ?></label>
                </div>
            </div>
            <?php endif; ?>

            <?php if(has_restriction()): ?>
            <div class="text-danger text-center font-italic small mb-1">
                <?php echo 'You are about to register into demo application to see the platform.'; ?>

            </div>
            <?php endif; ?>

            <div class="form-group">
                <?php echo csrf_field(); ?>
                <?php if(has_recaptcha()): ?>
                    <input type="hidden" id="recaptcha" value="" name="recaptcha">
                <?php endif; ?>
                <?php if($user_counts==0): ?>
                <input type="hidden" name="confirmation" value="on">
                <?php endif; ?>
                <button class="btn btn-lg btn-primary btn-block"><?php echo e(__('Register')); ?></button>
            </div>
        </form>
        <?php if($user_counts > 0): ?>
        <div class="form-note-s2 text-center pt-4">
            <?php echo e(__('Already have an account?')); ?> <a href="<?php echo e(route('auth.login.form')); ?>"><strong><?php echo e(__('Sign in instead')); ?></strong></a>
        </div>
        <?php endif; ?>
        <?php echo $__env->make('auth.partials.socials', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php if(has_recaptcha()): ?>
<?php $__env->startPush('scripts'); ?>
<script>
    grecaptcha.ready(function() {
        grecaptcha.execute('<?php echo e(recaptcha_key("site")); ?>', {action: 'register'}).then(function(token) {
            document.getElementById('recaptcha').value=token;
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make('auth.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/auth/register.blade.php ENDPATH**/ ?>